import re
import time
from lib.struct import ParkTime
from utils import FORMAT_TIME,LONG_TO_INT,TIME_TO_DATA
def FORMAT_PAY_DATA(PARK_ID,ORDER,workKey,transNo, transRand, obuId, Money, tac, cache):
    sysParam, cardParam, vehicleInfo = cache.get("sysParam"), cache.get("cardParam"), cache.get("vehicleInfo")
    parkTimeObject = ParkTime()
    parkTimeObject.exitTime = ORDER.get("exitTime")
    parkTimeObject.entryTime = ORDER.get("entryTime")
    parkTimeObject.get()

    parkId = PARK_ID
    vehplateNo = ORDER['plate']
    programStartTime = FORMAT_TIME("%Y-%m-%d %H:%M:%S")
    recordType = 1
    lane = int(ORDER['entryLane'])
    entryTime =TIME_TO_DATA(ORDER['entryTime'],"%Y%m%d%H%M%S") * 1000
    exitLane = int(ORDER['exitLane'])
    exitTime =TIME_TO_DATA(ORDER['exitTime'],"%Y%m%d%H%M%S") * 1000
    statisticDate = str(ORDER['statisticDate'])
    exitOperator = "a"
    exitShift = ORDER['shift']
    parkTime = parkTimeObject.ing  # 停车时长
    specialInfo = 1
    receivableTotalAmount = 10
    discountAmount = 0
    actualIncomeAmount = 10
    discountInfo = ""
    payAmount = int(ORDER['fee'])  # 金额动态获取
    payMethod = 2
    paySerialNo = ORDER['payNo']
    passMethod = 2
    cardSn =cardParam.cardNumber.hex()
    obuTransId = obuId
    obuId = sysParam.agrNumber.hex()  # 合同序列号
    transactionDate = FORMAT_TIME("%Y-%m-%d")
    Time = re.sub(r"(?<=\w)(?=(?:\w\w)+$)", ":", cache.get("transacTime"))
    fee = int(ORDER['fee'])   # 金额动态获取
    serviceType = 2
    transType = "09"
    terminalNo = workKey.termId
    issuerIdentifier = sysParam.serviceCode.hex()
    cardNetNo = cardParam.cardNetworkNumber.hex()  # 卡网络编号
    cardType = str(int(cardParam.cardType.hex(), base=16))  # 卡片类型
    preBalance = LONG_TO_INT(int(cache.get("preBalance").hex(), base=16))  # 卡前余额
    postBalance = LONG_TO_INT(int(Money, base=16))  # 卡后余额
    cardSerialNo = cache.get("cardSN").hex()  # 2字节卡内交易序号
    cardRandom = cache.get("passtypeRand").hex()  # 卡内随机数
    terminalTradeNo = cache.get("termNo")
    tac = tac
    algorithmIdentifier = 1
    deviceType = 9
    entryDate = int(FORMAT_TIME("%Y%m%d"))
    exitStation = 2010203
    deviceStatus = 0

    body = {
        "programStartTime": programStartTime,
        "recordNo": transRand,
        "transSn": transNo,
        "parkId": parkId,
        "recordType": recordType,
        "vehplateNo": vehplateNo,
        "vehplateColor": int(vehicleInfo.color.hex(), base=16),
        "vehType": int(vehicleInfo.type.hex(), base=16),
        "lane": lane,
        "entryTime": entryTime,
        "exitLane": exitLane,
        "exitTime": exitTime,
        "statisticDate": statisticDate,
        "exitOperator": exitOperator,
        "exitShift": exitShift,
        "parkTime": parkTime,
        "specialInfo": specialInfo,
        "seceivableTotalAmount": receivableTotalAmount,
        "discountAmount": discountAmount,
        "actualIncomeAmount": actualIncomeAmount,
        "discountInfo": "",
        "payAmount": payAmount,
        "payMethod": payMethod,
        "paySerialNo": paySerialNo,
        "passMethod": passMethod,
        "cardSn": f"{cardNetNo}{cardSn}",  # 完整卡号 4 + 16
        "obuTransId": obuTransId,
        "obuId": obuId,
        "transactionDate": transactionDate,
        "time": Time,
        "fee": fee,
        "serviceType": serviceType,
        "transType": transType,
        "terminalNo": terminalNo,
        "issuerIdentifier": issuerIdentifier,
        "cardNetNo": cardNetNo,
        "cardType": cardType,
        "preBalance": preBalance,
        "postBalance": postBalance,
        "cardSerialNo": cardSerialNo,
        "cardRandom": cardRandom,
        "terminalTradeNo": terminalTradeNo,
        "TAC": tac,
        "algorithmIdentifier": algorithmIdentifier,
        "deviceType": deviceType,
        "deviceNo": "__",
        "EntryDate": entryDate,
        "ExitStation": exitStation,
        "DeviceStatus": deviceStatus,
        "parkTimeStr": parkTimeObject.ingStr,
        "ProgramVer": "1, 0, 0, 1",
    }
    return body



def FORMAT_BOOK_KEEP_DATA(handlerCache,order,parkId,devNumber,hour):
    '''
    2022-09-26
    取消vehicle字段,改为plate
    取消payInfo,不再上传关于OBU内部信息
    '''
    transacNo = handlerCache.get("transacNo")
    enqueueStatus = handlerCache.get("enqueueStatus")
    content = {
        "payNo":order['payNo'],
        "transNumber":transacNo,
        "fee":order['fee'],
        "plate":order['plate'],
        "serviceId":parkId,
        "devNumber":devNumber,
        "hour":hour,
        "enqueueStatus":enqueueStatus,
        "shift":2,
        "uploadTime":int(time.time()),
        "uploadDate":FORMAT_TIME("%Y-%m-%d")
    }
    return content