from typing import Any
from enum import Enum
from lib.proxy import ProxyDataPlatform,OAuthModeEnum

from log import Logger
logger = Logger(__name__)
class ReqApi(Enum):
    GET_WORK_KEY = "/api/v1/gateway/platform/public/get/work/key/"
    GET_VEHICLE_INFO = "/api/v1/gateway/platform/public/dec/vehinfo/"
    GET_BLACKLIST = "/api/v1/gateway/platform/park/black/list/query/"
    GET_MAC2 = "/api/v1/gateway/platform/public/get/mac/"


async def ReqWorkSm4Key(rsuId:str)->Any:
    '''
    获取工作秘钥
    '''
    body = {
        "rsuId":rsuId
    }
    api = ReqApi.GET_WORK_KEY.value
    httpProxy = ProxyDataPlatform(OAuthModeEnum.V2.value)
    res = await httpProxy.get(api,body)
    if httpProxy.isErr:
        logger.error(httpProxy.errMsg)
        return -1
    return res


async def ReqVehicleInfo(rsuId:str,ciphertext:str,random:str,tradNo:str,_issueId:str,workKey:str)->Any:
    api = ReqApi.GET_VEHICLE_INFO.value
    body = {
        "rsuId": rsuId,
        "vehicleBody": {
            "vehInfo": ciphertext,
            "random": random[8:len(random)],
            "tradNo": tradNo,
            "divCode": f"{_issueId}{_issueId}"  # 中文部分重复两遍
        },
        "frameId": "1"
    }
    headers = {"sm4-key":workKey}
    httpProxy = ProxyDataPlatform(OAuthModeEnum.V2.value)
    res = await httpProxy.post(api,body,headers=headers,timeOut=3)
    if httpProxy.isErr:
        logger.error(httpProxy.errMsg)
        return -1
    return res

async def ReqBlackList(parkId:str,cardId:str,obuId:str,issueId:str)->Any:
    api = ReqApi.GET_BLACKLIST.value
    body = {
        "serviceId": parkId,
        "cardId": cardId,
        "obuId": obuId,
        "issueId": issueId
    }
    httpProxy = ProxyDataPlatform(OAuthModeEnum.V2.value)
    res = await httpProxy.post(api,body,timeOut=3)
    if httpProxy.isErr:
        logger.error(httpProxy.errMsg)
        return -1
    return res

async def ReqMac2(rsuId,transacTime,passtypeRand,terminalSN,money,cardParam,workKey):
    api = ReqApi.GET_MAC2.value
    data = {
        "cardId": cardParam.cardNumber.hex(),
        "random": passtypeRand.hex(),
        "treadNo": terminalSN.hex(),
        # "money": Struct("!i").pack(order.fee).hex(),
        # "money":'{:08X}'.format(order.fee),
        "money":money,
        "time": transacTime,
        "keyInfo": "0100",
        "issueId": f"{cardParam.issued.hex()[0:8]}{cardParam.issued.hex()[0:8]}"
    }
    body =  body = {
            "rsuId": rsuId,
            "frameId": "0",
            "getMacBody": data
        }
    httpProxy = ProxyDataPlatform(OAuthModeEnum.V2.value)
    headers = {"sm4-key":workKey}
    res = await httpProxy.post(api,body,headers=headers,timeOut=3)
    if httpProxy.isErr:
        logger.error(httpProxy.errMsg)
        return -1
    return res
