import redis
import json
import time
import random
from datetime import timedelta
from typing import Dict,Any
from enum import Enum
from set import MIDDLEWARE_PWD,PARK_ID
from utils import TIME_TO_DATA

class Tag(Enum):
    PAY = "#####"
    PAY_RES = "*****"

class Address(object):
    def __init__(self) -> None:
        self.ip = ''
        self.port = 0000

class RsuInitParam(object):
    power = ""
    channel = ""
    sn = ""
    interval = "" #心跳间隔

class WorkKey(object):
    def __init__(self,keyRes:Dict[str,str]) -> None:
        self.key = keyRes["key"]
        self.termId = keyRes["termId"]

class Mac2(object):
    def __init__(self,res) -> None:
        self.termNo = res[0:8]
        self.mac2 = res[8:16]

class ParkTime(object):
    def __init__(self) -> None:
        self._entryTime = ''
        self._exitTime = ''

    @property
    def entryTime(self):
        return self._entryTime

    @entryTime.setter
    def entryTime(self,value):
        self._entryTime = value

    
    @property
    def exitTime(self):
        return self._exitTime

    @exitTime.setter
    def exitTime(self,value):
        self._exitTime = value


    @property
    def ing(self):
        return self._ing

    @property
    def ingStr(self):
        return self._ingStr

    def get(self):
        self._ing = TIME_TO_DATA(self._exitTime,"%Y%m%d%H%M%S") - TIME_TO_DATA(self._entryTime,"%Y%m%d%H%M%S") #出场时间减去入场时间等于停车时间
        h,s,m = str(timedelta(seconds=self._ing)).split(':')
        self._ingStr = f"{h}小时{s}分{m}秒"




class SerialNumber(object):
    def __init__(self):
        self.time = time.strftime("%Y%m%d%H%M%S", time.localtime(int(time.time())))
        self.randint = random.randint(10, 99)

    def create(self, parkId):
        '''生成交易编号'''
        return f"{parkId}{self.time}{self.randint}"

class PaySignal(object):
    tag = Tag.PAY.value
    def __init__(self,address:Address) -> None:
        self.middleware = redis.Redis(
            host=address.ip,
            port=address.port,
            password=MIDDLEWARE_PWD,
            decode_responses=True
        )
    
    def GetPaySignal(self,lane):
        return self.middleware.get(f"{self.tag}{PARK_ID}{lane}")

    def SetPaySignal(self,orderItem:Dict[str,Any],lane:int):
        orderItemSrt = json.dumps(orderItem)
        self.middleware.set(f"{self.tag}{PARK_ID}{lane}", orderItemSrt)

    def ClearPaySignal(self,lane:int):
        self.middleware.set(f"{self.tag}{PARK_ID}{lane}", "")

class PayResSignal(object):
    tag = Tag.PAY_RES.value
    def __init__(self,address:Address) -> None:
        self.middleware = redis.Redis(
            host=address.ip,
            port=address.port,
            password=MIDDLEWARE_PWD,
            decode_responses=True
        )

    def GetPayRes(self,lane:int)->Any:
        startTime = int(time.time())
        while True:
            endTime = int(time.time())
            if endTime - startTime > 3:
                res = "E12-交易超时"
                break
            res = self.middleware.get(f"{self.tag}{PARK_ID}{lane}")
            if res:
                break
        return res

    def SetPayResSignal(self,res:str,lane:int):
        self.middleware.set(f"{self.tag}{PARK_ID}{lane}", res)

    def ClearResSignal(self,lane:int):
        self.middleware.set(f"{self.tag}{PARK_ID}{lane}", "")