from cacheout import LFUCache
from tornado.ioloop import IOLoop
from apscheduler.schedulers.asyncio import AsyncIOScheduler
from src.fun import ConnectRsu,start
from src.init import AppInit
from lib.struct import RsuInitParam,Address,PaySignal,PayResSignal
from set import RSU_IP,RSU_PORT,RSU_POWRE,RSU_CHANNEL,RSU_ID,INTERVAL,MIDDLEWARE_IP,MIDDLEWARE_PORT
from log import Logger
logger = Logger(__name__)

__version__ = "1.0.1"
__version_date__ = "2022.10.25"

cache = LFUCache() #运行时系统缓存
handlerCache =  LFUCache(ttl=5) #处理时过程缓存
async def app():
    rsuAddress = Address()
    rsuAddress.ip = RSU_IP
    rsuAddress.port = RSU_PORT

    rsuInitParam = RsuInitParam()
    rsuInitParam.power = RSU_POWRE
    rsuInitParam.channel = RSU_CHANNEL
    rsuInitParam.sn = RSU_ID
    rsuInitParam.interval = INTERVAL

    middlewareAddress = Address()
    middlewareAddress.ip,middlewareAddress.port = MIDDLEWARE_IP,MIDDLEWARE_PORT
    paySignal = PaySignal(middlewareAddress)
    payResSignal = PayResSignal(middlewareAddress)

    try:
        stream  = await ConnectRsu(rsuAddress)
    except Exception as e:
        logger.error(f"连接天线异常:{rsuAddress.ip}:{rsuAddress.port}重试次数已用完")
        exit()

    scheduler = AsyncIOScheduler() #定时任务控制器
    initRes = await AppInit(stream,scheduler,rsuInitParam,paySignal,payResSignal,cache)
    if initRes == -1:
        logger.error("系统初始化时异常")
        exit()
    try:
        await start(stream,scheduler,payResSignal,cache,handlerCache)
    except Exception as e:
        logger.error(f"系统主程序异常:{e}")
        exit()



if __name__ == '__main__':
    loop = IOLoop.current()
    loop.spawn_callback(app)
    loop.start()