from typing import Any
from enum import Enum
from cacheout import LFUCache
from tornado.iostream import IOStream
from apscheduler.schedulers.asyncio import AsyncIOScheduler

from lib.req import ReqWorkSm4Key
from lib.frame import TerFrame
from lib.push import PushDevOnline
from lib.struct import PayResSignal, PaySignal,RsuInitParam,WorkKey
from task.job import GetOrder,SendHeartbeat
from set import LANE,DEV_NUMBER

from log import Logger
logger = Logger(__name__)

class TaskSelect(Enum):
    TASK_HEARTBEAT = "0"
    TASK_GET_ORDER = "1"


def  RsuInit(stream:IOStream,power:int)->Any:
    tf = TerFrame(b'\x18',(power,),"!b")
    if tf.isErr:
        logger.error(tf.errMsg)
        return -1
    stream.write(tf.frame)

def TaskInit(stream:IOStream,scheduler:object,interval:int,paySignal:PaySignal,payResSignal:PayResSignal,cache:LFUCache)->Any:
    scheduler.add_job(
        GetOrder,
        'interval',
        seconds=0.05,
        id = TaskSelect.TASK_GET_ORDER.value,
        kwargs={
            "stream": stream,
            "paySignal":paySignal,
            "payResSignal":payResSignal,
            "lane":LANE,"cache":cache,
            "scheduler":scheduler
        }
    )  # 每50毫秒发送一次检测信号
    scheduler.add_job(
        SendHeartbeat,
        'interval',
        seconds=interval,
        id = TaskSelect.TASK_HEARTBEAT.value,
        kwargs={"stream":stream}
    )  # 每3秒发送一次心跳
    

async def AppInit(stream:IOStream,scheduler:AsyncIOScheduler,rsuInitParam:RsuInitParam,paySignal:PaySignal,payResSignal:PayResSignal,cache:LFUCache)->WorkKey:
    pushRes = await PushDevOnline(DEV_NUMBER)
    if pushRes == -1:
        logger.error(f"通知平台设备上线异常,但不影响系统初始化:{pushRes}")
        
    # ---------------------------------------------
    getKeyRes = await ReqWorkSm4Key(rsuInitParam.sn)
    if getKeyRes == -1:
        logger.error(f"获取工作秘钥时候异常:{pushRes}")
        return -1
    logger.info(f"工作秘钥:{getKeyRes}")

    workKey = WorkKey(getKeyRes)
    cache.set("workKey",workKey)
    
    taskRes = TaskInit(stream,scheduler,rsuInitParam.interval,paySignal,payResSignal,cache)
    if taskRes == -1:
        logger.error(f"初始化定时任务异常:{taskRes}")
        return -1

    rsuInitRse = RsuInit(stream,int(rsuInitParam.power))
    if rsuInitRse == -1:
        logger.error(f"初始化天线时异常:{rsuInitRse}")
        return -1
    scheduler.start()
    return workKey
