import json
import time
from enum import Enum
from lib.frame import TerFrame
from log import Logger
logger = Logger(__name__)

class TaskSelect(Enum):
    TASK_HEARTBEAT = "0"
    TASK_GET_ORDER = "1"

async def GetOrder(*args, **kwargs):
    cache = kwargs.get("cache")
    stream = kwargs.get("stream")
    paySignal = kwargs.get("paySignal")
    scheduler = kwargs.get("scheduler")
    lane = kwargs.get("lane")
    orderJsonStr = paySignal.GetPaySignal(lane)
    if not orderJsonStr:
        return
    newOrder = json.loads(orderJsonStr)
    oldOrder = cache.get("order")
    if oldOrder:
        if oldOrder['payNo'] == newOrder['payNo']: # 因为是异步执行防止在交易中再次捕获同一笔订单
            paySignal.ClearPaySignal(lane)
            return
    newOrder.update({"realRequestTime":int(time.time())})
    cache.set("order", newOrder,5)
    logger.info(f"{time.time()};收到订单消息:{newOrder}")
    scheduler.pause_job(TaskSelect.TASK_HEARTBEAT.value) # 暂时停止心跳,会影响交易链路
    tf = TerFrame(b'\x50',(b'\x80',b'\x00',b'\x02'),"!sss")
    stream.write(tf.frame)

async def  SendHeartbeat(*args, **kwargs):
    stream = kwargs.get("stream")
    tf = TerFrame(b'\x11',(1,0,0),"!bbb")
    stream.write(tf.frame)