
import json

from cacheout import LFUCache
from tornado.httpclient import AsyncHTTPClient, HTTPRequest, HTTPResponse

cache = LFUCache()  # clinet模块独立的缓存器


class HttpClient(object):
    def __init__(self) -> None:
        self.__headers = {}
        

    def set_header(self, herders: dict):
        self.__headers.update(herders)

    async def __client(self, _requests: HTTPRequest) -> HTTPResponse:
        httpClient = AsyncHTTPClient()
        r = await httpClient.fetch(_requests)
        return r
    
    async def post(self, url: str, body: dict, headers: dict, timeOut: int):
        if headers:
            self.set_header(headers)
        # url = url_concat(f"{self.protocol}://{self.host}{self.port}{url}", dict(_time=str(int(time.time()))))
        _requests = HTTPRequest(url=url,
                                method="POST",
                                body=json.dumps(body),
                                headers=self.__headers, request_timeout=timeOut,validate_cert=False)
        r = await self.__client(_requests)
        return r