from typing import Any,Dict
from lib.proxy import ProxyDataPlatform
from lib.config import cloudProxy
from log import app_log

logger = app_log(__name__)

async def WriteOff(body:Dict[str,Any])->Any:
    '''自由流向海康平台核销订单'''
    api = "/api/v1/free/pass/platform/order/Writeoff/"
    httpPorxy = ProxyDataPlatform()
    httpPorxy.host = cloudProxy.host
    httpPorxy.port = int(cloudProxy.port)
    await httpPorxy.post(api,body,timeOut=2)
    if httpPorxy.isErr:
        logger.error(httpPorxy.errMsg)
        return -1

async def WriteOffByGy(body:Dict[str,Any])->Any:
    '''自由流向冠宇平台核销订单'''
    api = "/api/v1/free/pass/platform/order/Writeoff/"
    httpPorxy = ProxyDataPlatform()
    httpPorxy.host = cloudProxy.host
    httpPorxy.port = int(cloudProxy.port)
    await httpPorxy.post(api,body,timeOut=2)
    if httpPorxy.isErr:
        logger.error(httpPorxy.errMsg)
        return -1


async def NoticePayFail(plateNo:str,inTime:str,orderNo:str,remark:str,parkId:str)->Any:
    '''通知科拓平台扣费失败'''
    api = "/api/v1/free/pass/platform/kt/penetrate/gateway/"
    workApi = "/apiPayment/nosense/failureNotice"
    data = {
        "parkId":parkId,
        "plateNo":plateNo,
        "inTime":inTime,
        "orderNo":orderNo,
        "remark":remark,
        "serviceCode":"FailureNotice"
    }

    body = {
        "api":workApi,
        "data":data
    }
    httpPorxy = ProxyDataPlatform()
    httpPorxy.host = cloudProxy.host
    httpPorxy.port = int(cloudProxy.port)
    await httpPorxy.post(api,body,timeOut=2)
    if httpPorxy.isErr:
        logger.error(httpPorxy.errMsg)
        return -1

async def ConfirmOrRelieveSigned(data:Dict[str,Any],isSigned:int)->Any:
    '''签约或解除签约'''
    api = "/api/v1/free/pass/platform/kt/penetrate/gateway/"
    workApi = "/api/nosense/Signing"
    data = {
            "parkId":data.get("parkId"),
            "serviceCode":"signing",
            "plateNo":data.get("plateNo"),
            "signed":isSigned, #默认所有车装载OBU
            "payMethod":1008, #支付方式 ETC支付
            "inTime":data.get("entryTime") #进场时间
        }

    body = {
        "api":workApi,
        "data":data
    }
    httpPorxy = ProxyDataPlatform()
    httpPorxy.host = cloudProxy.host
    httpPorxy.port = int(cloudProxy.port)
    await httpPorxy.post(api,body,timeOut=2)
    if httpPorxy.isErr:
        logger.error(httpPorxy.errMsg)
        return -1
    