# -*- coding: utf-8 -*-

import tornado.web
from tornado.httpserver import HTTPServer
from apscheduler.schedulers.tornado import TornadoScheduler
from tornado.ioloop import IOLoop
from tornado.options import define, options

from handler.cmd import PayHandler,RevokePayHandler,CheckPayHandler,TestHandler,FreePassVerificationHandler,TestCallbackHadnler
from handler.custom_made import EnterContractHnadler,KtcustomMadePayHandler
from lib.config import service,session

from log import app_log
logger = app_log(__name__)

define("port", default=service.port, type=int)


class SessionApplication(tornado.web.Application):
    def __init__(self):
        handlers = [
            ("/api/v1/rec/service/test/",TestHandler),
            ("/api/v1/rec/service/pay/",PayHandler), #扣款
            # ("/api/v1/rec/service/sgx/pay/",XgsPayHandler), #扣款
            ("/api/v1/rec/service/cleartext/pay/",PayHandler), #扣款
            ("/api/v1/rec/service/revoke/pay/",RevokePayHandler), #撤销扣款
            ("/api/v1/rec/service/cleartext/revoke/pay/",RevokePayHandler), #撤销扣款
            ("/api/v1/rec/service/check/pay/",CheckPayHandler), #对账
            ("/api/v1/rec/service/enter/push/PostCarInInfo",EnterContractHnadler), #科拓定制进场上报
            ("/api/v1/rec/service/exit/pay/PostPayment",KtcustomMadePayHandler), # 科拓定制扣费
            ("/api/v1/rec/service/hk/pay/writeoff/",FreePassVerificationHandler), # 自由流定制扣费向海康平台核销订单
            ("/api/v1/rec/service/test/pay/callback/",TestCallbackHadnler), # 自由流定制扣费向海康平台核销订单
        ]

        settings = dict(
            debug=service.debug,
            login_url="/api/v1/pay/data/platform/403/"
        )
        # sid_name, lifetime added in 1.1.5.0
        # sid_name: the name of session id in cookies.
        # lifetime: session default expires seconds.
        session_settings = dict(
            driver='redis',
            # driver_settings={'host': self},
            driver_settings=dict(
                host=session.host,
                port=session.port,
                db=session.db,
                max_connections=session.maxConnections,
                password=session.password
            ),
            force_persistence=True,
            sid_name='torndsessionID',
            session_lifetime=session.sessionLifetime)
        settings.update(session=session_settings)
        # super(SessionApplication, self).__init__(handlers, **settings)
        tornado.web.Application.__init__(self, handlers, **settings)


if __name__ == '__main__':
    scheduler = TornadoScheduler()
    tornado.options.parse_command_line()
    app = SessionApplication()
    app.scheduler = scheduler
    http_server = HTTPServer(app)
    http_server.listen(options.port)
    IOLoop.current().start()