# -*- coding: utf-8 -*-

import tornado.web
from tornado.httpserver import HTTPServer
from apscheduler.schedulers.tornado import TornadoScheduler
from tornado.ioloop import IOLoop
from tornado.options import define, options
from handler.api import UpdatesManyHandler
from lib.config import service,session

from log import app_log
logger = app_log(__name__)

define("port", default=service.port, type=int)


class SessionApplication(tornado.web.Application):
    def __init__(self):
        handlers = [
           ("/api/v1/om/service/update/",UpdatesManyHandler)
        ]

        settings = dict(
            debug=service.debug,
            login_url="/api/v1/pay/data/platform/403/"
        )
        # sid_name, lifetime added in 1.1.5.0
        # sid_name: the name of session id in cookies.
        # lifetime: session default expires seconds.
        session_settings = dict(
            driver='redis',
            # driver_settings={'host': self},
            driver_settings=dict(
                host=session.host,
                port=session.port,
                db=session.db,
                max_connections=session.maxConnections,
                password=session.password
            ),
            force_persistence=True,
            sid_name='torndsessionID',
            session_lifetime=session.sessionLifetime)
        settings.update(session=session_settings)
        # super(SessionApplication, self).__init__(handlers, **settings)
        tornado.web.Application.__init__(self, handlers, **settings)


if __name__ == '__main__':
    scheduler = TornadoScheduler()
    tornado.options.parse_command_line()
    app = SessionApplication()
    app.scheduler = scheduler
    http_server = HTTPServer(app)
    http_server.listen(options.port)
    IOLoop.current().start()