
from .base import BaseHandler
from db.database import mysqlClient
from log import log

logger = log(__name__)
class QueryOrderDetailHandler(BaseHandler):
    async def post(self):
        data = self.json()
        payNo = data.get("payNo")
        sql = '''
        SELECT
        a.payNo AS pay_no,
        a.requestTime as requestTime,
        a.realRequestTime as realRequestTime,
        a.insertTime AS insert_time,
        b.res AS res,
        c.callback_status AS callback_status,
        c.callback_time AS callback_time,
        c.callback_err AS callback_err,
        d.revokeTime AS revoke_time,
        d.res AS revoke_res
        FROM
            book_keep a
        LEFT JOIN res_query b ON
            a.payNo = b.payNo
        LEFT JOIN callback_res c ON
            a.payNo = c.pay_no
        LEFT JOIN trade_revoke d ON
            a.payNo = d.payNo
        where a.payNo = %s
        '''
        try:
            cur = await mysqlClient.execute(sql,(payNo,))
            qs = await cur.fetchall()
        except Exception as e:
            logger.error(f"查询交易链异常:{e}")
            return self.write_resp500("服务器内部异常")
        return self.write_resp200(list(qs))