import time

from src.submit_orders import OrderProcessor,FailOrderProcessor
from src.confirm_orders import Reconciliation
from src.statistica_probability import Probability,SubmitProbabilityManager
from utils import TimeConversion,ReadConf
from log import log

logger = log(__name__)
async def submit_orders(*args, **kwargs):
    """
    处理订单的完整流程
    """
    query_date = TimeConversion.ToDate("%Y-%m-%d",int(time.time()))
    api = "/api/v1/park/order/controller/bookkeep/"
    order_processor = OrderProcessor(api,query_date)
    orders = await order_processor.get_orders_to_submit()
    format_orders = order_processor.format_orders(orders)
    res = await order_processor.submit_orders(format_orders)
    if res == -1:
        return
    submit_fail_orders = res
    update_status_orders = list(set(order_processor.orders) - set(submit_fail_orders))
    await order_processor.update_order_status(update_status_orders, 1) #成功上传
    await order_processor.update_order_status(submit_fail_orders, 2) #上传失败


async def submit_failed_trans_list(*args, **kwargs):
    query_date = TimeConversion.ToDate("%Y-%m-%d",int(time.time()))
    submitUrl = "/api/v1/park/order/controller/enqueue/"
    failOrderProcessor = FailOrderProcessor(submitUrl,query_date)
    orders = await failOrderProcessor.get_orders_to_submit()
    format_orders = failOrderProcessor.format_orders(orders)
    if not orders:return

    logger.info(f"本次应提交失败入队记录:{len(format_orders)}")
    res = await failOrderProcessor.submit_orders(format_orders)
    if res == -1:
        return
    await failOrderProcessor.update_order_status(1)
    

async def submit_pay_probability(*args, **kwargs):
    '''提交控制器扣费概率'''
    manager_config = ReadConf("MANAGER")
    box_sn = manager_config.get("ID")
    statistical_date = TimeConversion.yesterday("%Y%m%d")
    logger.info(f"统计日期===========>:{statistical_date}")
    submit_url = "/api/v1/dev/platform/park/terminal/etcp/probability/push/"
    probability = Probability(box_sn,statistical_date)
    manager = SubmitProbabilityManager(submit_url,probability)
    try:
        res = await manager.submit()
    except Exception as e:
        logger.error(f"推送扣费概率异常:{e}")
        return
    if res == -1:
        logger.error(f"推送扣费概率失败:{res}")

async def confirm_orders(*args, **kwargs):
    manager_config = ReadConf("MANAGER")
    service_id_str = manager_config.get("SERVICE_ID")
    service_id_list = service_id_str.split('|')
    query_date = TimeConversion.yesterday("%Y-%m-%d")
    logger.info(f"对账日期:{query_date}")
    for service_id in service_id_list:
        reconciliation = Reconciliation(service_id=service_id,type=1,start_date=query_date,start_hour=-1)
        try:
            local_data = await reconciliation.query_local_data()
        except Exception as e:
            logger.error(f"查询本地账单时异常:{e}")
            return
        logger.info(f"local_data_len:{len(local_data)}")
        try:
            await reconciliation.run(local_data)
        except Exception as e:
            logger.error(f"对账过程中异常:{e};{service_id}")
            continue
        logger.info(f"{service_id}对账完成")