import os
import hashlib
import time
from datetime import timedelta, datetime

import yaml

# 项目根路径
BASE_PATH: str = os.path.dirname(os.path.abspath(__file__))

def ReadConf(module):
    with open(rf'{BASE_PATH}/conf/service.yaml') as f:
        cmd = yaml.safe_load(f)
    return cmd.get(module)


class Sign(object):
    def __init__(self) -> None:
        super().__init__()
        self._param = ""

    @property
    def param(self):
        return self._param

    @param.setter
    def param(self, value):
        self._param = value

    def _md5(self, _str):
        # 创建md5对象
        hl = hashlib.md5()
        # Tips
        # 此处必须声明encode
        # 若写法为hl.update(str)  报错为： Unicode-objects must be encoded before hashing
        hl.update(_str.encode(encoding='utf-8'))
        return hl.hexdigest()

    def sign(self):
        # 签名认证
        keys = sorted(self._param.keys())
        key_str = "".join(keys)
        values_str = ""
        for key in keys:
            values_str += str(self._param[key])
        s = "{}{}".format(
            key_str,
            values_str.replace('\'', '').replace(' ', '').replace('\"', ''))
        # 加密
        signature_str1 = self._md5(s)
        # 加盐加密na
        signature_str = self._md5("NCSS-SASH-{}".format(signature_str1))
        return signature_str


class TimeConversion(object):
    def __init__(self):
        pass

    @staticmethod
    def ToDate(fmt,timestamp):
        return time.strftime(fmt, time.localtime(timestamp))

    @staticmethod
    def yesterday(fmt):
        day = datetime.today() + timedelta(-1)
        return day.strftime(fmt)


    @staticmethod
    def tomorrow(fmt):
        day = datetime.today() + timedelta(1)
        return day.strftime(fmt)
