from tornado.ioloop import IOLoop

from src.app_manager import MianManager
from log import Logger
logger = Logger(__name__)

__version__ = "2.1.0"
__version_date__ = "2024.02.02"

async def app():
    mainManager = MianManager()
    try:
        await mainManager.init()
    except Exception as e:
        logger.error(f"应用初始化异常:{e}")
        mainManager.scheduler.shutdown()
        exit()

    try:
        await mainManager.start() #主程序开始
    except Exception as e:
        logger.error(f"主逻辑异常:{e}")
        exit()


if __name__ == '__main__':
    loop = IOLoop.current()
    try:
        loop.spawn_callback(app)
        loop.start()
    except KeyboardInterrupt as e:
        pass