from pymongo import MongoClient
class MongoClientProxy(object):
    def __init__(self):
        super().__init__()
        self._host = ""
        self._port = 0000
        self.maxPoolSize = 10
        self.client = None

    def conn(self):
        self.client =  MongoClient(self.host, self.port, maxPoolSize=self.maxPoolSize)

    def install(self,dbName,table,data):
        db = self.client[dbName]
        col = db[table]
        col.insert_one(data)

    def query(self,dbName,table,fields =[],where = {}):
        dic = {}
        for field in fields:
            dic[field] = 1
        db = self.client[dbName]
        col = db[table]
        qs = col.find(where,dic)
        return qs

mongoClient = MongoClientProxy()
mongoClient.host = '127.0.0.1'
mongoClient.port = 27017
mongoClient.conn()


# a = {"_id":13,"a":"无敌","b":2,"c":3}

# mongoClient.install('test_db','work',a)
# qs = mongoClient.query('book_keep_content','order')
qs = mongoClient.client.test_db.work.find({"_id":{"$in":[12,13]}})
for i in qs:
    print(i)