from .base import BaseHandler
from src.operate import OperateFileEnum
from src.fun import updates
from log import app_log
logger = app_log(__name__)

class UpdatesManyHandler(BaseHandler):
    async def post(self):
        OPERATE_PATH = "/opt/operate/"
        data = self.json()
        try:
            logger.info(f"收到更新策略...:{data}")
            path = f"{OPERATE_PATH}{OperateFileEnum.UPDATES.value}"
            cmd = f"/opt/operate/*venv/bin/python3 {path} {data['download_url']} {data['package_type']} {data['callback_url']} {data['version']} {data['version_time']} {data['operate_code']} {data['sn']}"
            #cmd = f"python3 {path} {data['download_url']} {data['package_type']} {data['callback_url']} {data['version']} {data['version_time']} {data['operate_code']} {data['sn']}"
            self.write_resp200("") # 先断开连接后续异步执行脚本
            res = updates(cmd)
        except Exception as e:
            logger.error(f"发起更新异常:{e}")
            return self.write_resp500(f"服务器内部异常")

        if res == -1:
            logger.error(f"发起更新失败:{res}")
            return self.write_resp500("服务器内部异常")