from handler.record import BookKeepHandler,FailedTransactionSaveHandler,ParkOrderConfirmHandler,TestHandler,TransactionResSaveHandler,UpdateKeepHandler,RevokeHandler,BookKeepQueryHandler,CallBackHandler
from handler.query import QueryOrderDetailHandler
from task.job import submit_orders,submit_failed_trans_list,submit_pay_probability,confirm_orders
import tornado.web
from tornado.httpserver import HTTPServer
from tornado.ioloop import IOLoop
from tornado.options import define, options
from apscheduler.schedulers.tornado import TornadoScheduler
from log import log
from utils import ReadConf

logger = log(__name__)
server = ReadConf("SERVER")
session = ReadConf("SESSION")

define("port", default=server.get("PORT", 9001), type=int)


class SessionApplication(tornado.web.Application):
    def __init__(self):
        handlers = [
            ("/api/v1/terminal/record/service/test/",TestHandler),
            ("/api/v1/terminal/record/service/keep/",BookKeepHandler),
            ("/api/v1/terminal/record/service/query/keep/",BookKeepQueryHandler),
            ("/api/v1/terminal/record/service/update/keep/",UpdateKeepHandler),
            ("/api/v1/terminal/record/service/failed/transac/",FailedTransactionSaveHandler),
            ("/api/v1/terminal/record/service/transaction/record/res/",TransactionResSaveHandler),
            ("/api/v1/terminal/record/service/transaction/record/revoke/",RevokeHandler),
            ("/api/v1/terminal/record/service/transaction/record/callback/",CallBackHandler),
            ("/api/v1/terminal/record/service/transaction/query/order/detail/",QueryOrderDetailHandler),
            ("/api/v1/terminal/record/service/transaction/park/order/confirm/",ParkOrderConfirmHandler)
        ]
        settings = dict(
            debug=server.get("DEBUG"),
            login_url="/api/v1/pay/data/platform/403/"
        )
        # sid_name, lifetime added in 1.1.5.0
        # sid_name: the name of session id in cookies.
        # lifetime: session default expires seconds.
        session_settings = dict(
            driver='memory',
            driver_settings={'host': self},
            force_persistence=True,
            sid_name='torndsessionID',
            session_lifetime=1800
        )
        settings.update(session=session_settings)
        # super(SessionApplication, self).__init__(handlers, **settings)
        tornado.web.Application.__init__(self, handlers, **settings)


if __name__ == '__main__':
    scheduler = TornadoScheduler()
    scheduler.add_job(submit_orders,'interval',seconds=30) # 订单提交
    scheduler.add_job(submit_failed_trans_list,'interval',seconds=30) # 失败交易数据提交
    scheduler.add_job(submit_pay_probability,'cron', day_of_week='0-6', hour=10, minute=32, second=0) # 上传前一天支付控制器扣费信息
    scheduler.add_job(confirm_orders,'cron', day_of_week='0-6', hour=1, minute=30, second=0) # 对账
    scheduler.start()
    tornado.options.parse_command_line()
    app = SessionApplication()
    app.scheduler = scheduler
    http_server = HTTPServer(app)
    http_server.listen(options.port)
    IOLoop.current().start()