from enum import Enum

from set import *
class ConfigModuleEnum(Enum):
    APP_BUSINESS_MODULE = "APP_BUSINESS"
    RSU_MODULE = "RSU"
    REDIS_MODULE = "REDIS"
    PARXY_MODULE = "PORXY"
    RECORD_MODULE = "RECORD"
    EMAIL_MODULE = "EMAIL"
    AUTH_MODULE = "AUTH"

class ConfigMangaer(object):
    def __init__(self) -> None:
        self.configModuleMap = {
            "APP_BUSINESS":APP_BUSINESS,
            "RSU":RSU,
            "REDIS":REDIS,
            "PORXY":PORXY,
            "EMAIL":EMAIL,
            "AUTH":AUTH,
            "RECORD":RECORD
        }


    def load(self,configModuleEnum:ConfigModuleEnum)->dict:
        return self.configModuleMap.get(configModuleEnum.value)