from enum import Enum


ISSUED_MAP = {
    "北京": "11", "天津": "12", "河北": "13", "山西": "14", "内蒙": "15",
    "辽宁": "21", "吉林": "22", "龙": "23","龙江":"23", "上海": "31", "江苏": "32",
    "浙江": "33", "安徽": "34", "福建": "35", "江西": "36", "山东": "37", "河南": "41",
    "湖北": "42", "湖南": "43", "广东": "44", "广西": "45", "海南": "46",
    "重庆": "50", "贵州": "52", "云南": "53", "西藏": "54",
    "陕西": "61", "甘肃": "62", "青海": "63", "宁夏": "64", "新疆": "65",
    "台湾地区": "71", "香港": "81", "澳门": "82"
}

class ONLINE_KEY_FIELD(Enum):
    STEP1 = [
        "obuMac",
        "obuInfoLen",
        "obuInfo",
        "cardInfoLen",
        "cardInfo",
        "vehicleInfoLen",
        "vehicleInfo"
    ]
    STEP2 = [
        "obuMac",
        "banlance",
        "passtypeRand",
        "cardSN"
    ]
    STEP3 = [
        "obuMac",
        "mac2",
        "tac",
        "banlance"    
        ]
    
class PARAM_FIELD(Enum):
    PARAM_FIELD_BY_OBU_INF0 = [
        "serviceCode",
        "agrType",
        "agrVersion",
        "agrNumber",
        "startDate",
        "expiredDate",
        "isDisassembly"
    ]
    PARAM_FIELD_BY_CARD_INF0 = [
        "issued",
        "cardType",
        "cardVersion",
        "cardNetworkNumber",
        "cardNumber",
        "startTime",
        "endTime",
        "plate",
        "fic"
    ]
    PARAM_FIELD_BY_VEHICLE_INF0 = [
        "ciphertext",
        "random",
        "x"
    ]

    PARAM_FIELD_BY_VEHICLE_FIELD = [
            "plate", # 车牌号
            "color", # 车牌颜色
            "type",# 车型
            "userType",# 车辆用户类型
            "size", #车辆尺寸(长2字节宽1字节高1字节单位:dm)
            "tiresNumber", # 车轮数
            "axleNumber", # 车轴数
            "axleWidth", #轴距,单位:dm
            "load", # 车辆载重/座位数，其中,载重的单位为:kg
            "feature", # 车辆特征描述
            "engineNumber" # 车辆发动机号
        ]


class PARAM_FMT(Enum):
    FMT_BY_OBU = "!8sss8s4s4ss"
    FMT_BY_CARD = "!8sss2s8s4s4s12s3s"
    FMT_BY_VEHICLE = "!80s8s8s"
    FMT_BY_VEHICLE_PARAM = "!12s2sss4sss2s3s16s16s"
    
class ONLINE_KEY_FMT(Enum):
    STEP1 = "!4ss27ss43ss96s"
    STEP2 = "!4s4s4s2s"
    STEP3 = "!4s4s4s4s"


class ResSelect(Enum):
    E00 = "ok"
    E01 = "E01-天线故障"
    E02 = "E02-未装ETC"
    E03 = "E03-ETC拆卸"
    E04 =" E04-ETC未插卡"
    E05 = "E05-ETC未绑定"
    E06 = "E06-ETC失效"
    E07 = "E07-车牌不符"
    E08 = "E08-非陕西卡"
    E09 = "E09-ETC黑名单"
    E10 = "E10-余额不足"
    E11 = "E11-交易失败"
    E12 = "E12-交易超时"
    E13 = "E13-未知"
    E14 = "E14-读卡错误"
    E15 = "E15-云端不通"
    E16 = "E16-云端异常"
    E17 = "E17-超额消费"
    E18 = "E18-取TAC失败"
    E19 = "E19-记账B卡"


class TaskSelect(Enum):
    TASK_HEARTBEAT = "0"
    TASK_GET_ORDER = "1"
    TASK_ISRSUSTREAMCONNECT = "2"