import yagmail
from enum import Enum
from typing import Any
from lib.config_manager import ConfigMangaer,ConfigModuleEnum

from log import Logger
logger = Logger(__name__)
CM = ConfigMangaer()
configByEmail = CM.load(ConfigModuleEnum.EMAIL_MODULE)

class AlarmLevel(Enum):
    WARNING = "警告"
    SERIOUS = "严重"
    URGENT = "紧急"


class AlarmType(Enum):
    NOT_RECORD_MODULE_REPLY = "记录组件停止服务" #记录组件未响应
    PUSH_TRADE_DATE_FAIL = "交易数据上传失败"

class AlarmMsgManager(object):
    def __init__(self,title="",msg="") -> None:
        self.title = title
        self.msg = msg
    
    def send(self,contact):
        # 发送告警
        email = Email()
        email.send(self.title,self.msg,contact)

class Email(object):
    def __init__(self) -> None:
        self.host = configByEmail["EMAIL_GATEWAY_HOST"]
        self.gatewayPwd = configByEmail["EMAIL_GATEWAY_PWD"]
        self.sender = configByEmail["SENDER"]


    def send(self,alarmTitle:str,alarmlMsg:str,contact:str="")->Any:
        print(f"alarmTitle:{alarmTitle};alarmlMsg:{alarmlMsg};contact:{contact}")
        print(self.sender)
        print(self.gatewayPwd)
        print(self.host)
        print(contact)
        try:
            yag = yagmail.SMTP(user=self.sender, password=self.gatewayPwd, host=self.host)
            yag.send(to=contact, subject=alarmTitle, contents=alarmlMsg)
        except Exception as e:
            sendErrMsg = f"邮件发送时异常:{e}"
            logger.error(sendErrMsg)
            raise RuntimeError(sendErrMsg)

def AlarmContentTemplate(parkId,payNo,alarmTime,**kwargs):
        template = f"停车场编号: {parkId}\n时间: {alarmTime}\n订单号: {payNo}"
        return template