import yaml
import time
import os
from datetime import timedelta, datetime
# 项目根路径
BASE_PATH: str = os.path.dirname(os.path.abspath(__file__))
def ReadConf(module):
    with open(rf'{BASE_PATH}/conf/conf.yaml') as f:
        cmd = yaml.safe_load(f)
    return cmd.get(module)

class TimeConversion(object):
    def __init__(self):
        self._timestamp = 0
        self._fmt = ""

    @property
    def timestamp(self):
        return self._timestamp

    @timestamp.setter
    def timestamp(self, value):
        self._timestamp = value

    @property
    def fmt(self):
        return self._fmt

    @fmt.setter
    def fmt(self, value):
        self._fmt = value

    def ToDate(self):
        return time.strftime(self._fmt, time.localtime(self._timestamp))

    def yesterday(self):
        day = datetime.today() + timedelta(-1)
        return day.strftime(self.fmt)

def FORMAT_TIME(fmt):
    localTime = time.localtime(int(time.time()))
    return time.strftime(fmt, localTime)

def FORMAT_TIME2(fmt):
    timestamp = datetime.timestamp(datetime.now())
    formatted_time = datetime.fromtimestamp(timestamp).strftime(fmt)
    return formatted_time