from utils import ReadConf


class RedisConfig(object):
    conf = ReadConf("REDIS")
    host = conf.get("HOST")
    port = conf.get("PORT")
    password = conf.get("PASSWORD")

class ServiceConfig(object):
    conf = ReadConf("SERVER")
    port = conf.get("PORT")
    debug = conf.get("DEBUG")


class LocalProxyConfig(object):
    conf = ReadConf("PROXY")
    host = conf.get("HOST")
    port = conf.get("PORT")
    protovol=conf.get("PROTOVOL")

class CloudProxyConfig(object):
    conf = ReadConf("CLOUD_PROXY")
    host = conf.get("HOST")
    port = conf.get("PORT")
    protovol=conf.get("PROTOVOL")

class SessionConfig(object):
    conf = ReadConf("SESSION")
    host = conf.get("HOST")
    port =conf.get("PORT")
    db = conf.get("DB")
    maxConnections = conf.get("MAX_CONNECTIONS")
    password = conf.get("PASSWORD")
    sessionLifetime = conf.get("SESSION_LIFETIME")


_redis = RedisConfig()
service = ServiceConfig()
localProxy = LocalProxyConfig()
cloudProxy = CloudProxyConfig()
session = SessionConfig()